function k=VectOnde(E,m,Ep)
% VectOnde retourne le vecteur d'onde k d'un objet physique  partir de son
%   nergie totale, de sa masse et des valeurs de l'nergie potentielle 
%   Ep  laquelle elle est soumise. 
%
%   k=VectOnde(E,m,Ep)
%       >> E    = Energie de l'objet physique (eV);
%       >> m    = Masse de l'objet physique (relative  la masse de l'lectron);
%       >> Ep   = Energie(s) potentielle(s) Ep(i) (eV), (i=1,2,...) ;
%       << k    = Vecteur(s) d'onde k(i) (nm^-1).
%                           
%   Olivier Pujol : septembre 2013
%
%% Vrification

if (m<=0),error('La masse doit tre strictement positive !');end

%% Constantes et conversions

h=6.6260755E-34;    %   Constante de Planck (J.s)
hbar=h/(2*pi);
hbar2=hbar^2;
me=0.91093897E-30;  %   Masse de l'lectron (kg)
eV=1.60217733E-19;  %   Electronvolt (J) 
%
m=m*me;
E=E*eV;
nm=1E-9;

%% Calcul des vecteurs d'onde

k=nan(size(Ep));
if (length(m)>1)
    for n=1:length(Ep)
        Ep(n)=Ep(n)*eV;
        if (Ep(n)<E), k(n)=sqrt( (2*m(n)/hbar2).*(E-Ep(n)) );end
        if (Ep(n)>E), k(n)=i*sqrt( (2*m(n)/hbar2).*(Ep(n)-E) );end
        if (Ep(n)==E),error('Une des valeurs de E conduit au cas singulier k=0 !');end
    end
end
if (length(m)==1)
    for n=1:length(Ep)
        Ep(n)=Ep(n)*eV;
        if (Ep(n)<E), k(n)=sqrt( (2*m/hbar2)*(E-Ep(n)) );end
        if (Ep(n)>E), k(n)=i*sqrt( (2*m/hbar2)*(Ep(n)-E) );end
        if (Ep(n)==E),error('Une des valeurs de E conduit au cas singulier k=0 !');end
    end
end
%
k=k*nm;
%
return;